---
noteId: "m17b5y80237ygvf3n2ddjf60f57ytz4c"
title: "Copy on Write の次"
tags: []
updatedAt: 1767847700064
docName: "notes:m17b5y80237ygvf3n2ddjf60f57ytz4c/content"
---

Copy on Write の branching が実装できた。これで branch 作成がかなり低コストで実行できるようになった

docStates というフィールドが分岐後に触られる度に増えていく問題があるが、これは branch を cleanup した後に、必要ないものを削除して減らしていけるはずだ

あとは main を branch の分岐点までは GC + S3 にアーカイブするようにして、それ以降だけのアクティブなものだけが DB に残るようにできれば、コスト的にも小さくできるはずだ

branch の読み込み自体は、その分岐点の checkpoint があればいつでも確認できるはず。branch への書き込みも、その checkpoint 時点の docStates が別の方法で取り出すことができるのなら、別にいつまで残していても大した問題はない気がする


もうちょっと発想を進めよう。branch を作成するのが本当に低コストなんだったら、sandbox 内で working docs と ref docs を分けて管理する必要がない気がする。どのドキュメントも編集できるようにしてもいい。配置時に branch を切ってもいいし、編集があった瞬間に branch を作成する遅延作成でもあんまり問題はないはずだ（main で書き込みが発生していないか hash などで確認する必要があるが）

その方がやっぱり理想的だな。どれだけを編集してもいいよっていうのは結構複雑になる。その代わりにどれを編集してもいいよっていう方がとてもシンプルな設計にできる。編集があったときに main と差分がなければそれを適当する前に branch を作成して、すでに main が更新されていたらそれを取り込んでから branch を作成すればいい。


そこまでちゃんと sandbox を使いやすくするんだったら、やっぱり git と一緒に使いたくなる。git repository の中に paperx ディレクトリを配置して、タスクごとにそこに必要な情報をロードするとか。paperx で管理している情報と一緒に開発したり、レポジトリの内容を paperx に出力したりもしやすくなる。

sandbox での編集でも、一緒に repository をロードしておいてやると、コードを読みながらドキュメントを編集することもできる。github cli で issue をとってきて作業をまとめたりも可能だ。

そこまでやろうとしたら、独立した CLI をインストールして、そこから使えるようにする必要があるかな

メモリの更新とかもローカルで試せるようになるし、嬉しいだろうな。


あとは CRDT 的にやっぱり履歴が大きくなったらどうしても重たくなるので、どこかのタイミングで type を clone して作り直す仕組みをちゃんと入れておきたいな。共同編集のセッションが存在しないタイミングでやる仕組みと、連続しない変更が行われたらエラーになるようにする仕組みが必要か。

